import discord

from discord.ext import commands

from discord import app_commands

afk_users = {}

class AFK(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @app_commands.command(name="afk", description="Se mettre en mode AFK avec une raison")

    async def afk(self, interaction: discord.Interaction, raison: str = "AFK"):

        afk_users[interaction.user.id] = raison

        await interaction.response.send_message(f"🛑 {interaction.user.mention} est maintenant AFK : **{raison}**")

    @commands.Cog.listener()

    async def on_message(self, message):

        if message.author.bot:

            return

        # Si l'utilisateur était AFK et parle → on l'enlève

        if message.author.id in afk_users:

            del afk_users[message.author.id]

            await message.channel.send(f"✅ {message.author.mention} est de retour.")

        # Si quelqu'un mentionne un AFK → répondre avec la raison

        for mention in message.mentions:

            if mention.id in afk_users:

                await message.channel.send(f"💤 {mention.display_name} est AFK : **{afk_users[mention.id]}**")

async def setup(bot):

    await bot.add_cog(AFK(bot))